/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf;

import io.gitlab.jfronny.commons.tuple.Tuple;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Flags {
    public static Set<StringFlag> getStringFlags(String name) {
        return Flags.getFlags(name, StringFlag::new, StringFlag::new).collect(Collectors.toUnmodifiableSet());
    }

    public static Set<BooleanFlag> getBoolFlags(String name) {
        return Flags.getFlags(name, BooleanFlag::new, BooleanFlag::new).collect(Collectors.toUnmodifiableSet());
    }

    public static BooleanFlag getBoolFlag(String name) {
        return Flags.getFlags(name, BooleanFlag::new, BooleanFlag::new).map(dt -> Tuple.of(dt.source, dt.value)).collect(Tuple.collector(Collectors.joining(", "), Collectors.reducing(false, (l, r) -> l | r))).accept(BooleanFlag::new);
    }

    private static <T> Stream<T> getFlags(String name, BiFunction<String, String, T> makeFromProp, BiFunction<String, CustomValue, T> makeFromFmj) {
        Stream<Object> fromProps = Stream.ofNullable(System.getProperty("libjf." + name)).map(prop -> makeFromProp.apply("System Property", (String)prop));
        Stream<T> fromMods = Flags.getLibjfBlocks().map(Tuple.mappingRight(co -> co.get(name))).filter(co -> co.right() != null).map(Tuple.mappingLeft(id -> "Mod: " + id)).map(Tuple.accepting(makeFromFmj));
        return Stream.concat(fromProps, fromMods);
    }

    private static Stream<Tuple<String, CustomValue.CvObject>> getLibjfBlocks() {
        return FabricLoader.getInstance().getAllMods().stream().map(mod -> Tuple.of(mod.getMetadata().getId(), mod.getMetadata().getCustomValue("libjf"))).filter(co -> co.right() != null).map(Tuple.mappingRight(CustomValue::getAsObject));
    }

    public record BooleanFlag(String source, boolean value) {
        public BooleanFlag(String source, String value) {
            this(source, BooleanFlag.parse(source, value));
        }

        public BooleanFlag(String source, CustomValue value) {
            this(source, value.getAsBoolean());
        }

        private static boolean parse(String source, String value) {
            return switch (value = value.toLowerCase(Locale.ROOT).trim()) {
                case "" -> true;
                case "yes", "true" -> true;
                case "no", "false" -> false;
                default -> throw new IllegalStateException("Unexpected boolean value: " + value + " (from " + source + ")");
            };
        }
    }

    public record StringFlag(String source, String value) {
        public StringFlag(String source, CustomValue value) {
            this(source, value.getAsString());
        }
    }
}

